function [ F ] = fct_CDF_F_capped(t,mu,sigma)
% CDF of the times tau a Brownian motion {X(t)} with (mu,sigma)  hits
%X(tau)=1 starting at X(0)=0.
%
mu_orig = mu;
mu = abs(mu);  % make mu>0

modet  = 1/mu*((1+9/(4*mu^2/sigma^4))^0.5-3/(2*mu/sigma^2));
stdev = sqrt(sigma^2/mu^3);

if 2*mu/sigma^2 < 700;
%
    F = normcdf( -(1-mu.*t)./(sigma.*sqrt(t)) ) + exp(2*mu./sigma^2).*normcdf( -(1+mu.*t)./(sigma.*sqrt(t)) );
%
else
   %F = 0;
   % F = 0 for t < mode-stdev
   select = t <=(modet - stdev);
   F(select) = 0;
   % F = 1 for t > mode+stdev
   select = t >(modet + stdev);
   F(select) = 1;
   % in between, just linear approximation
   select = (t>(modet - stdev))& (t <=(modet + stdev));
   Ns = sum(select);
   F(select) = [1:1:Ns]/Ns;
end

% negative mu
    if mu_orig <0 
        F = exp(-2*mu/sigma^2)*F;
    end
    
% special case
    if sigma == 0 && mu_orig <0
        F = 0*F;
    end


end

